<?php
// ==== CONFIGURATION ==== //

// Increase execution time to prevent timeout
ini_set('max_execution_time', 1200);
set_time_limit(1200);

// Enable error logging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . "/cron_error.log");

// Check if running via CLI (cron) or browser
$isCron = php_sapi_name() === 'cli';

// Log execution mode
file_put_contents(__DIR__ . "/cron_debug.log", date("Y-m-d H:i:s") . " - Running in " . ($isCron ? "CRON MODE" : "BROWSER MODE") . "\n", FILE_APPEND);

// ==== STREAMS ==== //
$streams = [
    "https://azura.broadcasterr.co/listen/lick88fm/radio.mp3",
    "http://broadcast.shoutstream.co.uk/stream/8044",
    "http://c22.radioboss.fm:8808/groovechill"
];

// Path to the proxies file
$proxyFile = __DIR__ . "/proxies.txt";

// Random listener count per stream (10-20 per stream)
$numListenersPerStream = rand(20, 50);

// Random listening durations (2, 10, 15, 30 minutes, and some for 1-2 hours)
$listeningDurations = [120, 600, 900, 1800, 3600]; // options

// ==== LOAD PROXIES ==== //
$proxies = file($proxyFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

if (!$proxies) {
    error_log("No proxies found in proxies.txt");
    file_put_contents(__DIR__ . "/cron_debug.log", "No proxies found in proxies.txt\n", FILE_APPEND);
    die("No proxies found in proxies.txt\n");
}

// User-agents for simulating real users
$userAgents = [
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36",
    "Mozilla/5.0 (iPhone; CPU iPhone OS 14_0 like Mac OS X) AppleWebKit/537.36 (KHTML, like Gecko) Version/14.0 Mobile/15E148 Safari/537.36",
];

// Track active listeners per stream
$activeListeners = array_fill_keys($streams, 0);

// Function to introduce random delays
function randomDelay($min, $max)
{
    sleep(rand($min, $max));
}

// ==== IMMEDIATE CONNECTION: One Proxy Per Stream ==== //
foreach ($streams as $stream) {
    if (count($proxies) == 0) {
        break;
    }

    $proxy = $proxies[array_rand($proxies)]; // Random proxy for each stream
    list($proxyIp, $proxyPort) = explode(":", $proxy);
    $userAgent = $userAgents[array_rand($userAgents)];
    $listenTime = $listeningDurations[array_rand($listeningDurations)];
    $proxyType = (strpos($proxy, "socks5") !== false) ? CURLPROXY_SOCKS5 : CURLPROXY_HTTP;

    // Log attempt
    file_put_contents(__DIR__ . "/cron_log.txt", date("Y-m-d H:i:s") . " - Attempting to connect $proxyIp:$proxyPort to $stream\n", FILE_APPEND);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $stream);
    curl_setopt($ch, CURLOPT_PROXY, $proxyIp);
    curl_setopt($ch, CURLOPT_PROXYPORT, $proxyPort);
    curl_setopt($ch, CURLOPT_PROXYTYPE, $proxyType);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, $listenTime);
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Connection: keep-alive',
        'Accept: */*',
        'Cache-Control: no-cache',
        'Pragma: no-cache',
        'Upgrade-Insecure-Requests: 1',
        'Accept-Encoding: gzip, deflate',
        'Accept-Language: en-US,en;q=0.9',
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode == 200) {
        file_put_contents(__DIR__ . "/successful_connections.log", 
            "$proxyIp:$proxyPort - Connected to $stream for $listenTime seconds (HTTP Code: $httpCode)\n", FILE_APPEND);
        $activeListeners[$stream]++;
    } else {
        file_put_contents(__DIR__ . "/failed_connections.log", 
            "$proxyIp:$proxyPort - Failed to $stream (HTTP Code: $httpCode)\n", FILE_APPEND);
    }
}

// ==== STAGGERED CONNECTIONS: Adding More Listeners Every 1-5 Minutes Per Stream ==== //
while (max($activeListeners) < $numListenersPerStream) {
    foreach ($streams as $stream) {
        if ($activeListeners[$stream] >= $numListenersPerStream) {
            continue;
        }

        randomDelay(60, 300); // Wait 1-5 minutes before adding new listener

        $proxy = $proxies[array_rand($proxies)];
        list($proxyIp, $proxyPort) = explode(":", $proxy);
        $userAgent = $userAgents[array_rand($userAgents)];
        $listenTime = $listeningDurations[array_rand($listeningDurations)];
        $proxyType = (strpos($proxy, "socks5") !== false) ? CURLPROXY_SOCKS5 : CURLPROXY_HTTP;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $stream);
        curl_setopt($ch, CURLOPT_PROXY, $proxyIp);
        curl_setopt($ch, CURLOPT_PROXYPORT, $proxyPort);
        curl_setopt($ch, CURLOPT_PROXYTYPE, $proxyType);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, $listenTime);
        curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Connection: keep-alive',
            'Accept: */*',
            'Cache-Control: no-cache',
            'Pragma: no-cache',
            'Upgrade-Insecure-Requests: 1',
            'Accept-Encoding: gzip, deflate',
            'Accept-Language: en-US,en;q=0.9',
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200) {
            file_put_contents(__DIR__ . "/successful_connections.log", 
                "$proxyIp:$proxyPort - Connected to $stream for $listenTime seconds (HTTP Code: $httpCode)\n", FILE_APPEND);
            $activeListeners[$stream]++;
        }
    }
}

// Log final listener count
file_put_contents(__DIR__ . "/cron_log.txt", date("Y-m-d H:i:s") . " - Total listeners per stream: " . json_encode($activeListeners) . "\n", FILE_APPEND);

if (!$isCron) {
    echo "Browser Mode: Started listeners for all streams.<br>";
}
?>